#include <bits/stdc++.h>
using namespace std;

int binarySearch(const vector<int>& arr, int target) {
    int low = 0, high = arr.size() - 1;
    while (low <= high) {
        int mid = low + (high - low) / 2;
        if (arr[mid] == target) return mid;
        else if (arr[mid] < target) low = mid + 1;
        else high = mid - 1;
    }
    return -1;
}

struct doublet {
    int w, v;
};

int main() {
    int n, W, e;
    cin >> n >> W >> e;

    vector<doublet> ponco(n + 1);   // index from 1 to n

    for (int i = 1; i <= n; i++) {
        int vi, wi;
        cin >> vi >> wi;
        ponco[i].v = vi;
        ponco[i].w = wi;
    }

    // DP table
    vector<vector<int>> res(W + 1, vector<int>(n + 1, 0));

    for (int j = 1; j <= n; j++) {
        for (int i = 1; i <= W; i++) {
            if (ponco[j].w <= i) {
                res[i][j] = max(ponco[j].v + res[i - ponco[j].w][j - 1],
                                 res[i][j - 1]);
            } else {
                res[i][j] = res[i][j - 1];
            }
        }
    }

    // Reconstruction
    vector<int> chosen;
    int i = W, j = n;

    while (i > 0 && j > 0) {
        if (res[i][j] == res[i][j - 1]) {
            j--;
        } else {
            chosen.push_back(j);
            i -= ponco[j].w;
            j--;
        }
    }

    cout << chosen.size() << "\n";
    reverse(chosen.begin(), chosen.end());
    for (int x : chosen)
        cout << x-1 << " ";

    return 0;
}